/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureContainer;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureDrawInfo;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFigure
extends AbstractFigure
implements FigureContainer,
Observer {
    protected Vector fFigures = new Vector();
    private static final long serialVersionUID = 7408153435700021866L;
    private int compositeFigureSerializedDataVersion = 1;

    protected CompositeFigure() {
    }

    public void add(Figure figure) {
        if (!this.fFigures.contains(figure)) {
            this.fFigures.addElement(figure);
            figure.setContainer(this);
            figure.addObserver(this);
        }
    }

    public void addAll(Vector newFigures) {
        Enumeration k = newFigures.elements();
        while (k.hasMoreElements()) {
            this.add((Figure)k.nextElement());
        }
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().moveBy(x, y);
        }
    }

    @Override
    public void draw(Graphics g) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().draw(g);
        }
    }

    @Override
    public void draw(Graphics g, FigureDrawInfo fdi) {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().draw(g, fdi);
        }
    }

    public Figure figureAt(int i) {
        return (Figure)this.fFigures.elementAt(i);
    }

    @Override
    public final FigureEnumeration figures() {
        return new FigureEnumerator(this.fFigures);
    }

    public final FigureEnumeration figuresReverse() {
        return new ReverseFigureEnumerator(this.fFigures);
    }

    @Override
    public Figure findFigureInside(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure().findFigureInside(x, y);
            if (figure == null) continue;
            return figure;
        }
        return null;
    }

    @Override
    public void forceUpdate() {
        if (this.container() != null) {
            this.container().forceUpdate();
        }
    }

    @Override
    public boolean includes(Figure figure) {
        if (super.includes(figure)) {
            return true;
        }
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (!f.includes(figure)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invalidate(Rectangle rect) {
        if (this.container() != null) {
            this.container().invalidate(rect);
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        int size = dr.readInt();
        this.fFigures = new Vector(size);
        for (int i = 0; i < size; ++i) {
            this.add((Figure)dr.readStorable());
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.setContainer(this);
            figure.addObserver(this);
        }
    }

    @Override
    public void release() {
        super.release();
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.deleteObserver(this);
            figure.release();
        }
    }

    public void remove(Figure figure) {
        if (this.fFigures.contains(figure)) {
            figure.deleteObserver(this);
            figure.setContainer(null);
            this.fFigures.removeElement(figure);
        }
    }

    public void removeAll() {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            figure.deleteObserver(this);
            figure.setContainer(null);
        }
        this.fFigures.removeAllElements();
    }

    public void removeAll(Vector figures) {
        Enumeration k = figures.elements();
        while (k.hasMoreElements()) {
            this.remove((Figure)k.nextElement());
        }
    }

    @Override
    public Figure removeFromDrawing(Figure figure) {
        if (this.container() != null) {
            return this.container().removeFromDrawing(this);
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fFigures.size());
        Enumeration k = this.fFigures.elements();
        while (k.hasMoreElements()) {
            dw.writeStorable((Storable)k.nextElement());
        }
    }

    public List<Figure> getFigure(Class cls) {
        ArrayList<Figure> figures = new ArrayList<Figure>();
        for (int i = 0; i < this.fFigures.size(); ++i) {
            Figure f = (Figure)this.fFigures.get(i);
            if (!cls.isInstance(f)) continue;
            figures.add(f);
        }
        return figures;
    }
}

